<?php

declare(strict_types=1);

namespace Cocode\DBModel\DataMapper;

use Nette\Database\Table\ActiveRow;

abstract class RowMapper extends CommonMapper implements DataMapperInterface, RowMapperInterface
{
    protected ?ActiveRow $_row = null;
    protected ?int $id;
    public const ID_FIELD = 'id';

    public function __construct($input = null)
    {
        if ($input instanceof ActiveRow) {
            $this->_row = $input;
            $data = $input->toArray();
        } else {
            $data = clone $input;
        }
        if (key_exists(self::ID_FIELD, $data) && !$data[self::ID_FIELD]) {
            $data[self::ID_FIELD] = null;
        }
        $this->mapPropertiesData($data);
    }

    public function getRow(): ?ActiveRow
    {
        return $this->_row;
    }

    public function setRow(ActiveRow $row): RowMapperInterface
    {
        $this->_row = $row;
        $this->mapPropertiesData($row->toArray());
        return $this;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $id): self
    {
        $this->id = $id;
        return $this;
    }
}
