<?php

declare(strict_types=1);

namespace Cocode\DBModel;


use Nette\Database\Explorer;

abstract class DBModelRepository
{
    use DBModelTrait;

    public function __construct(
        Explorer $database,
        string $tableName,
        ?string $entityClassName = null
    ) {
        $this->database = $database;
        $this->tableName = $tableName;
        $this->entityClassName = $entityClassName;
        $this->ensureEntityClassExists();
    }
}
