<?php
declare(strict_types=1);

namespace Cocode\DBModel\DataMapper;


class MapperMethodsCache
{
    protected static array $cache = [];

    public static function cache(string $entityName, string $method): void
    {
        if (!key_exists($entityName, self::$cache)) {
            self::$cache[$entityName] = [];
        }
        if (!in_array($method, self::$cache[$entityName])) {
            self::$cache[$entityName][] = $method;
        }
    }

    public static function isCached(string $entityName, string $method): bool
    {
        return (key_exists($entityName, self::$cache) && in_array($method, self::$cache[$entityName]));
    }
}
