<?php

declare(strict_types=1);

namespace Cocode\DBModel\DataMapper;

use Nette\Utils\Strings;

abstract class CommonMapper implements DataMapperInterface
{
    public function supports($input): bool
    {
        return ($input instanceof \ArrayAccess && $input instanceof \Traversable) || is_array($input);
    }

    /**
     * @param array $input
     * @return array
     */
    public function mapPropertiesData($input): array
    {
        if (!$this->supports($input)) {
            throw new \InvalidArgumentException(
                'CommonMapper supports only arrays or ArrayAccess and Traversable for data mapping input.'
            );
        }
        $rest = [];
        foreach ($input as $key => $value) {
            $fnName = 'set' . preg_replace('/\s/', '', Strings::capitalize(preg_replace('/_+/', ' ', $key)));
            if (MapperMethodsCache::isCached(get_class($this), $fnName) || method_exists($this, $fnName)) {
                call_user_func([$this, $fnName], $value);
                MapperMethodsCache::cache(get_class($this), $fnName);
            } else {
                $rest[$key] = $value;
            }
        }
        return $rest;
    }

    public function exportPropertiesData(array $keys): array
    {
        $output = [];
        foreach ($keys as $key) {
            $suffix = preg_replace('/\s/', '', Strings::capitalize(preg_replace('/_+/', ' ', $key)));
            $fnName = 'get' . $suffix;
            $altFnName = 'is' . $suffix;
            if (MapperMethodsCache::isCached(self::class, $fnName) || is_callable([$this, $fnName])) {
                $output[$key] = call_user_func([$this, $fnName]);
                MapperMethodsCache::cache(self::class, $fnName);
            } else {
                if (MapperMethodsCache::isCached(self::class, $altFnName) || is_callable([$this, $altFnName])) {
                    $output[$key] = call_user_func([$this, $altFnName]);
                    MapperMethodsCache::cache(self::class, $altFnName);
                }
            }
        }
        return $output;
    }
}
